/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.modcore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ModCoreInstaller {
    private static final String VERSION_URL = "https://api.sk1er.club/modcore_versions";
    private static final String className = "club.sk1er.mods.core.ModCore";
    private static boolean errored = false;
    private static String error;
    private static File dataDir;
    private static boolean isRunningModCore;

    public static boolean isIsRunningModCore() {
        return isRunningModCore;
    }

    private static boolean isInitalized() {
        try {
            LinkedHashSet<String> objects = new LinkedHashSet<String>();
            objects.add(className);
            Launch.classLoader.clearNegativeEntries(objects);
            Field invalidClasses = LaunchClassLoader.class.getDeclaredField("invalidClasses");
            invalidClasses.setAccessible(true);
            Object obj = invalidClasses.get(ModCoreInstaller.class.getClassLoader());
            ((Set)obj).remove(className);
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            ignored.printStackTrace();
            return false;
        }
    }

    public static boolean isErrored() {
        return errored;
    }

    public static String getError() {
        return error;
    }

    private static void bail(String error) {
        errored = true;
        ModCoreInstaller.error = error;
    }

    private static JsonHolder readFile(File in) {
        try {
            return new JsonHolder(FileUtils.readFileToString((File)in));
        }
        catch (IOException iOException) {
            return new JsonHolder();
        }
    }

    public static void initializeModCore(File gameDir) {
        if (!ModCoreInstaller.isIsRunningModCore()) {
            return;
        }
        try {
            Class<?> modCore = Class.forName(className);
            Method instanceMethod = modCore.getMethod("getInstance", new Class[0]);
            Method initialize = modCore.getMethod("initialize", File.class);
            Object modCoreObject = instanceMethod.invoke(null, new Object[0]);
            initialize.invoke(modCoreObject, gameDir);
            System.out.println("Loaded ModCore Successfully");
            return;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            System.out.println("Did NOT ModCore Successfully");
            return;
        }
    }

    public static int initialize(File gameDir, String minecraftVersion) {
        File modcoreFile;
        if (ModCoreInstaller.isInitalized()) {
            return -1;
        }
        dataDir = new File(gameDir, "modcore");
        if (!dataDir.exists() && !dataDir.mkdirs()) {
            ModCoreInstaller.bail("Unable to create necessary files");
            return 1;
        }
        JsonHolder jsonHolder = ModCoreInstaller.fetchJSON(VERSION_URL);
        String latestRemote = jsonHolder.optString(minecraftVersion);
        boolean failed = jsonHolder.getKeys().size() == 0 || jsonHolder.has("success") && !jsonHolder.optBoolean("success");
        File metadataFile = new File(dataDir, "metadata.json");
        JsonHolder localMetadata = ModCoreInstaller.readFile(metadataFile);
        if (failed) {
            latestRemote = localMetadata.optString(minecraftVersion);
        }
        if (!(modcoreFile = new File(dataDir, "Sk1er Modcore-" + latestRemote + " (" + minecraftVersion + ").jar")).exists() || !localMetadata.optString(minecraftVersion).equalsIgnoreCase(latestRemote) && !failed) {
            File old = new File(dataDir, "Sk1er Modcore-" + localMetadata.optString(minecraftVersion) + " (" + minecraftVersion + ").jar");
            if (old.exists()) {
                old.delete();
            }
            if (!ModCoreInstaller.download("https://static.sk1er.club/repo/mods/modcore/" + latestRemote + "/" + minecraftVersion + "/ModCore-" + latestRemote + " (" + minecraftVersion + ").jar", latestRemote, modcoreFile, minecraftVersion, localMetadata)) {
                ModCoreInstaller.bail("Unable to download");
                return 2;
            }
        }
        ModCoreInstaller.addToClasspath(modcoreFile);
        if (!ModCoreInstaller.isInitalized()) {
            ModCoreInstaller.bail("Something went wrong and it did not add the jar to the class path. Local file exists? " + modcoreFile.exists());
            return 3;
        }
        isRunningModCore = true;
        return 0;
    }

    public static void addToClasspath(File file) {
        try {
            URL url = file.toURI().toURL();
            ClassLoader classLoader = ModCoreInstaller.class.getClassLoader();
            Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, url);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private static boolean download(String url, String version, File file, String mcver, JsonHolder versionData) {
        url = url.replace(" ", "%20");
        System.out.println("Downloading ModCore  version " + version + " from: " + url);
        JFrame frame = new JFrame("ModCore Initializer");
        JProgressBar bar = new JProgressBar();
        TextArea comp = new TextArea("", 1, 1, 3);
        frame.getContentPane().add(comp);
        frame.getContentPane().add(bar);
        GridLayout manager = new GridLayout();
        frame.setLayout(manager);
        manager.setColumns(1);
        manager.setRows(2);
        comp.setText("Downloading Sk1er ModCore Library Version " + version + " for Minecraft " + mcver);
        comp.setSize(399, 80);
        comp.setEditable(false);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension preferredSize = new Dimension(400, 225);
        bar.setSize(preferredSize);
        frame.setSize(preferredSize);
        frame.setResizable(false);
        bar.setBorderPainted(true);
        bar.setMinimum(0);
        bar.setStringPainted(true);
        frame.setVisible(true);
        frame.setLocation(dim.width / 2 - frame.getSize().width / 2, dim.height / 2 - frame.getSize().height / 2);
        Font font = bar.getFont();
        bar.setFont(new Font(font.getName(), font.getStyle(), font.getSize() * 4));
        comp.setFont(new Font(font.getName(), font.getStyle(), font.getSize() * 2));
        try {
            int read;
            URL u = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)u.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(true);
            connection.addRequestProperty("User-Agent", "Mozilla/4.76 (Sk1er Modcore Initializer)");
            connection.setReadTimeout(15000);
            connection.setConnectTimeout(15000);
            connection.setDoOutput(true);
            InputStream is = connection.getInputStream();
            int contentLength = connection.getContentLength();
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            System.out.println("MAX: " + contentLength);
            bar.setMaximum(contentLength);
            bar.setValue(0);
            while ((read = is.read(buffer)) > 0) {
                outputStream.write(buffer, 0, read);
                bar.setValue(bar.getValue() + 1024);
            }
            outputStream.close();
            FileUtils.write((File)new File(dataDir, "metadata.json"), (CharSequence)versionData.put(mcver, version).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            frame.dispose();
            return false;
        }
        frame.dispose();
        return true;
    }

    public static final JsonHolder fetchJSON(String url) {
        return new JsonHolder(ModCoreInstaller.fetchString(url));
    }

    public static final String fetchString(String url) {
        url = url.replace(" ", "%20");
        System.out.println("Fetching " + url);
        try {
            URL u = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)u.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(true);
            connection.addRequestProperty("User-Agent", "Mozilla/4.76 (Sk1er ModCore)");
            connection.setReadTimeout(15000);
            connection.setConnectTimeout(15000);
            connection.setDoOutput(true);
            InputStream is = connection.getInputStream();
            return IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Failed to fetch";
        }
    }

    static {
        dataDir = null;
        isRunningModCore = false;
    }

    static class JsonHolder {
        private JsonObject object;

        public JsonHolder(JsonObject object) {
            this.object = object;
        }

        public JsonHolder(String raw) {
            if (raw == null) {
                this.object = new JsonObject();
            } else {
                try {
                    this.object = new JsonParser().parse(raw).getAsJsonObject();
                }
                catch (Exception e) {
                    this.object = new JsonObject();
                    e.printStackTrace();
                }
            }
        }

        public JsonHolder() {
            this(new JsonObject());
        }

        public String toString() {
            if (this.object != null) {
                return this.object.toString();
            }
            return "{}";
        }

        public JsonHolder put(String key, boolean value) {
            this.object.addProperty(key, Boolean.valueOf(value));
            return this;
        }

        public void mergeNotOverride(JsonHolder merge) {
            this.merge(merge, false);
        }

        public void mergeOverride(JsonHolder merge) {
            this.merge(merge, true);
        }

        public void merge(JsonHolder merge, boolean override) {
            JsonObject object = merge.getObject();
            for (String s : merge.getKeys()) {
                if (!override && this.has(s)) continue;
                this.put(s, object.get(s));
            }
        }

        private void put(String s, JsonElement element) {
            this.object.add(s, element);
        }

        public JsonHolder put(String key, String value) {
            this.object.addProperty(key, value);
            return this;
        }

        public JsonHolder put(String key, int value) {
            this.object.addProperty(key, (Number)value);
            return this;
        }

        public JsonHolder put(String key, double value) {
            this.object.addProperty(key, (Number)value);
            return this;
        }

        public JsonHolder put(String key, long value) {
            this.object.addProperty(key, (Number)value);
            return this;
        }

        private JsonHolder defaultOptJSONObject(String key, JsonObject fallBack) {
            try {
                return new JsonHolder(this.object.get(key).getAsJsonObject());
            }
            catch (Exception e) {
                return new JsonHolder(fallBack);
            }
        }

        public JsonArray defaultOptJSONArray(String key, JsonArray fallback) {
            try {
                return this.object.get(key).getAsJsonArray();
            }
            catch (Exception e) {
                return fallback;
            }
        }

        public JsonArray optJSONArray(String key) {
            return this.defaultOptJSONArray(key, new JsonArray());
        }

        public boolean has(String key) {
            return this.object.has(key);
        }

        public long optLong(String key, long fallback) {
            try {
                return this.object.get(key).getAsLong();
            }
            catch (Exception e) {
                return fallback;
            }
        }

        public long optLong(String key) {
            return this.optLong(key, 0L);
        }

        public boolean optBoolean(String key, boolean fallback) {
            try {
                return this.object.get(key).getAsBoolean();
            }
            catch (Exception e) {
                return fallback;
            }
        }

        public boolean optBoolean(String key) {
            return this.optBoolean(key, false);
        }

        public JsonObject optActualJSONObject(String key) {
            try {
                return this.object.get(key).getAsJsonObject();
            }
            catch (Exception e) {
                return new JsonObject();
            }
        }

        public JsonHolder optJSONObject(String key) {
            return this.defaultOptJSONObject(key, new JsonObject());
        }

        public int optInt(String key, int fallBack) {
            try {
                return this.object.get(key).getAsInt();
            }
            catch (Exception e) {
                return fallBack;
            }
        }

        public int optInt(String key) {
            return this.optInt(key, 0);
        }

        public String defaultOptString(String key, String fallBack) {
            try {
                return this.object.get(key).getAsString();
            }
            catch (Exception e) {
                return fallBack;
            }
        }

        public String optString(String key) {
            return this.defaultOptString(key, "");
        }

        public double optDouble(String key, double fallBack) {
            try {
                return this.object.get(key).getAsDouble();
            }
            catch (Exception e) {
                return fallBack;
            }
        }

        public List<String> getKeys() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry stringJsonElementEntry : this.object.entrySet()) {
                String key = (String)stringJsonElementEntry.getKey();
                list.add(key);
            }
            return list;
        }

        public double optDouble(String key) {
            return this.optDouble(key, 0.0);
        }

        public JsonObject getObject() {
            return this.object;
        }

        public boolean isNull(String key) {
            return this.object.has(key) && this.object.get(key).isJsonNull();
        }

        public JsonHolder put(String values, JsonHolder values1) {
            return this.put(values, values1.getObject());
        }

        public JsonHolder put(String values, JsonObject object) {
            this.object.add(values, (JsonElement)object);
            return this;
        }

        public void put(String blacklisted, JsonArray jsonElements) {
            this.object.add(blacklisted, (JsonElement)jsonElements);
        }

        public void remove(String header) {
            this.object.remove(header);
        }
    }
}

